
//firmware for GCA173 with PIC16F628(a) and octal GCA173_wheel_counter
//pulse extender for optogate with inverted outputs
//all outputs are normal high
//Output will be pulsed with the number of counted  wheels(x);  pulses are low active.
// counter contents generate the counted number pulses of 80 mSec with 80 mSec interval
//aug 17, 2023 initial start of this version
// 26 dec 2024 firmware corrected for low activce Pulse with GCA173_Wheel_counter pcb
Define CONF_WORD = 0x3f50
Define CLOCK_FREQUENCY = 4

CMCON = 7
TRISA = 255
TRISB = 0
PORTB = 255
AllDigital

Symbol gate1 = RA1
Symbol gate2 = RA2
Symbol gate3 = RA0
Symbol gate4 = RA3
Symbol gate5 = RA7
Symbol gate6 = RA4
Symbol gate7 = RA6
Symbol gate8 = RA5
Symbol fb1 = RB4
Symbol fb2 = RB5
Symbol fb3 = RB6
Symbol fb4 = RB7
Symbol fb5 = RB3
Symbol fb6 = RB2
Symbol fb7 = RB1
Symbol fb8 = RB0


Dim wheel_count1 As Byte
Dim wheel_count2 As Byte
Dim wheel_count3 As Byte
Dim wheel_count4 As Byte
Dim wheel_count5 As Byte
Dim wheel_count6 As Byte
Dim wheel_count7 As Byte
Dim wheel_count8 As Byte
Dim old_gate1 As Bit
Dim old_gate2 As Bit
Dim old_gate3 As Bit
Dim old_gate4 As Bit
Dim old_gate5 As Bit
Dim old_gate6 As Bit
Dim old_gate7 As Bit
Dim old_gate8 As Bit

Dim main_count As Word

wheel_count1 = 0
wheel_count2 = 0
wheel_count3 = 0
wheel_count4 = 0
wheel_count5 = 0
wheel_count6 = 0
wheel_count7 = 0
wheel_count8 = 0
// Timer1 Registers:
// Prescaler=1:8; TMR1 Preset=21010; Freq=11,22939Hz; Period=89.052.000 ns
//T1CON.5 = 1  // bits 5-4  Prescaler Rate Select bits
//T1CON.4 = 1
//T1CON.3 = 1  // bit 3 Timer1 Oscillator Enable Control: bit 1=on
//T1CON.2 = 1  //bit 2 Timer1 External Clock Input Synchronization Control bit: 1=Do not synchronize external clock input
//T1CON.1 = 0  // bit 1 Timer1 Clock Source Select bit: 0=Internal clock (FOSC/4) / 1 = External clock from pin T1CKI (on the rising edge)
//T1CON.0 = 1  // bit 0 enables timer
//TMR1H = 0x52  // preset for timer1 MSB register
//TMR1L = 0x12  // preset for timer1 LSB register

Call init()  // show all leds at start
T1CON.TMR1ON = 1  // bit 0 enables timer
main:



//opto_gate 1
	If gate1 = 0 Then  //reaction on low pulse
		If old_gate1 = 1 Then
			old_gate1 = 0  //further reaction disabled
			wheel_count1 = wheel_count1 + 1  // this count is done
		Endif
	Else
		old_gate1 = 1  // enable new count
	Endif


//opto_gate 2
	If gate2 = 0 Then  //reaction on low pulse
		If old_gate2 = 1 Then
			old_gate2 = 0  //further reaction disabled
			wheel_count2 = wheel_count2 + 1  // this count is done
		Endif
	Else
		old_gate2 = 1  // enable new count
	Endif

'opto_gate 3
	If gate3 = 0 Then  //reaction on low pulse
		If old_gate3 = 1 Then
			old_gate3 = 0  //further reaction disabled
			wheel_count3 = wheel_count3 + 1  // this count is done
		Endif
	Else
		old_gate3 = 1  // enable new count
	Endif

'opto_gate 4
	If gate4 = 0 Then  //reaction on low pulse
		If old_gate4 = 1 Then
			old_gate4 = 0  //further reaction disabled
			wheel_count4 = wheel_count4 + 1  // this count is done
		Endif
	Else
		old_gate4 = 1  // enable new count
	Endif

'opto_gate 5
	If gate5 = 0 Then  //reaction on low pulse
		If old_gate5 = 1 Then
			old_gate5 = 0  //further reaction disabled
			wheel_count5 = wheel_count5 + 1  // this count is done
		Endif
	Else
		old_gate5 = 1  // enable new count
	Endif

'opto_gate 6
	If gate6 = 0 Then  //reaction on low pulse
		If old_gate6 = 1 Then
			old_gate6 = 0  //further reaction disabled
			wheel_count6 = wheel_count6 + 1  // this count is done
		Endif
	Else
		old_gate6 = 1  // enable new count
	Endif

'opto_gate 7
	If gate7 = 0 Then  //reaction on low pulse
		If old_gate7 = 1 Then
			old_gate7 = 0  //further reaction disabled
			wheel_count7 = wheel_count7 + 1  // this count is done
		Endif
	Else
		old_gate7 = 1  // enable new count
	Endif

'opto_gate 8
	If gate8 = 0 Then  //reaction on low pulse
		If old_gate8 = 1 Then
			old_gate8 = 0  //further reaction disabled
			wheel_count8 = wheel_count8 + 1  // this count is done
		Endif
	Else
		old_gate8 = 1  // enable new count
	Endif

	main_count = main_count + 1
	Call outputcontrol()

Goto main

End
//On Interrupt

//	TMR1H = 0x52  ' preset for timer1 MSB register
//	TMR1L = 0x12  // preset for timer1 LSB register
//	Call outputcontrol()
//	T1CON.TMR1ON = 1  // bit 0 enables timer
//Resume
Proc outputcontrol()
	If main_count = 800 Then
// fb1
		If fb1 = 0 Then
			fb1 = 1  //pulse end
		Else
			If wheel_count1 > 0 Then
				wheel_count1 = wheel_count1 - 1
				fb1 = 0  // start newpulse
			Endif
		Endif

// fb2
		If fb2 = 0 Then
			fb2 = 1   //pulse end
		Else
			If wheel_count2 > 0 Then
				wheel_count2 = wheel_count2 - 1
				fb2 = 0  // start new pulse
			Endif
		Endif

// fb3
		If fb3 = 0 Then
			fb3 = 1   //pulse end
		Else
			If wheel_count3 > 0 Then
				wheel_count3 = wheel_count3 - 1
				fb3 = 0  // start new pulse
			Endif
		Endif

// fb4
		If fb4 = 0 Then
			fb4 = 1   //pulse end
		Else
			If wheel_count4 > 0 Then
				wheel_count4 = wheel_count4 - 1
				fb4 = 0  // start new pulse
			Endif
		Endif
// fb5
		If fb5 = 0 Then
			fb5 = 1   //pulse end
		Else
			If wheel_count5 > 0 Then
				wheel_count5 = wheel_count5 - 1
				fb5 = 0  // start new pulse
			Endif
		Endif
// fb6
		If fb6 = 0 Then
			fb6 = 1   //pulse end
		Else
			If wheel_count6 > 0 Then
				wheel_count6 = wheel_count6 - 1
				fb6 = 0  // start new pulse
			Endif
		Endif
// fb6
		If fb7 = 0 Then
			fb7 = 1   //pulse end
		Else
			If wheel_count7 > 0 Then
				wheel_count7 = wheel_count7 - 1
				fb7 = 0  // start new pulse
			Endif
		Endif
// fb8
		If fb8 = 0 Then
			fb8 = 1   //pulse end
		Else
			If wheel_count8 > 0 Then
				wheel_count8 = wheel_count8 - 1
				fb8 = 0  // start new pulse
			Endif
		Endif
	Else
		If main_count > 1600 Then
			main_count = 0
			PORTB =255
		Endif
	Endif


End Proc
Proc init()
	PORTB = 255
	fb1 = 0
	WaitMs 250
	fb1 = 1
	fb2 = 0
	WaitMs 250
	fb2 = 1
	fb3 = 0
	WaitMs 250
	fb3 = 1
	fb4 = 0
	WaitMs 250
	fb4 = 1
	fb5 = 0
	WaitMs 250
	fb5 = 1
	fb6 = 0
	WaitMs 250
	fb6 = 1
	fb7 = 0
	WaitMs 250
	fb7 = 1
	fb8 = 0
	WaitMs 250
	fb8 = 1
	PORTB = 255
End Proc